/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.GoblinRogueToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class WarrenWeirdingEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filterGoblin = new FilterCreaturePermanent();

    WarrenWeirdingEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Target player sacrifices a creature. If a Goblin is sacrificed this way, that player creates two 1/1 black Goblin Rogue creature tokens, and those tokens gain haste until end of turn";
    }

    private WarrenWeirdingEffect(WarrenWeirdingEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game) < 1) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !permanent.sacrifice(source, game)) {
            return false;
        }
        if (permanent.hasSubtype(SubType.GOBLIN, game)) {
            GoblinRogueToken token = new GoblinRogueToken();
            token.putOntoBattlefield(2, game, source, player.getId());
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Token)token, game)), source);
        }
        return true;
    }

    public WarrenWeirdingEffect copy() {
        return new WarrenWeirdingEffect(this);
    }

    static {
        filterGoblin.add((Predicate)SubType.GOBLIN.getPredicate());
    }
}

