/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.Mana;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class WasteNotLandTriggeredAbility
extends TriggeredAbilityImpl {
    WasteNotLandTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BasicManaEffect(Mana.BlackMana((int)2)), false);
    }

    private WasteNotLandTriggeredAbility(WasteNotLandTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WasteNotLandTriggeredAbility copy() {
        return new WasteNotLandTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.getControllerId()).contains(event.getPlayerId())) {
            Card discarded = game.getCard(event.getTargetId());
            return discarded != null && discarded.isLand(game);
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent discards a land card, add {B}{B}.";
    }
}

