/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.Graveyard;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class WatchersOfTheDeadEffect
extends OneShotEffect {
    WatchersOfTheDeadEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each opponent chooses two cards in their graveyard and exiles the rest";
    }

    private WatchersOfTheDeadEffect(WatchersOfTheDeadEffect effect) {
        super((OneShotEffect)effect);
    }

    public WatchersOfTheDeadEffect copy() {
        return new WatchersOfTheDeadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        if (controller != null) {
            for (UUID opponentId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null || opponent.equals(controller)) continue;
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(2, 2, new FilterCard());
                target.withNotTarget(true);
                Graveyard cardsInGraveyard = opponent.getGraveyard();
                if (cardsInGraveyard.size() <= 1) continue;
                opponent.choose(this.outcome, (Cards)cardsInGraveyard, (TargetCard)target, source, game);
                for (Card cardInGraveyard : cardsInGraveyard.getCards(game)) {
                    if (target.getTargets().contains(cardInGraveyard.getId())) continue;
                    opponent.moveCardToExileWithInfo(cardInGraveyard, CardUtil.getCardExileZoneId((Game)game, (UUID)source.getId()), sourceObject.getLogName(), source, game, Zone.GRAVEYARD, true);
                }
            }
            return true;
        }
        return false;
    }
}

