/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WaveOfVitriolEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public WaveOfVitriolEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player sacrifices all artifacts, enchantments, and nonbasic lands they control. For each land sacrificed this way, its controller may search their library for a basic land card and put it onto the battlefield tapped. Then each player who searched their library this way shuffles";
    }

    private WaveOfVitriolEffect(WaveOfVitriolEffect effect) {
        super((OneShotEffect)effect);
    }

    public WaveOfVitriolEffect copy() {
        return new WaveOfVitriolEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<Player, Integer> sacrificedLands = new HashMap<Player, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                int count = 0;
                for (Permanent permanent : game.getBattlefield().getAllActivePermanents(filter, playerId, game)) {
                    if (!permanent.sacrifice(source, game) || !permanent.isLand(game)) continue;
                    ++count;
                }
                if (count <= 0) continue;
                sacrificedLands.put(player, count);
            }
            game.processAction();
            CardsImpl toBattlefield = new CardsImpl();
            LinkedHashSet playersToShuffle = new LinkedHashSet();
            for (Map.Entry entry : sacrificedLands.entrySet()) {
                if (!((Player)entry.getKey()).chooseUse(Outcome.PutLandInPlay, "Search your library for up to " + entry.getValue() + " basic lands?", source, game)) continue;
                TargetCardInLibrary target = new TargetCardInLibrary(0, ((Integer)entry.getValue()).intValue(), (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
                if (!((Player)entry.getKey()).searchLibrary(target, source, game) || target.getTargets().isEmpty()) continue;
                toBattlefield.addAll((Collection)target.getTargets());
                playersToShuffle.add(entry.getKey());
            }
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, true, false, true, null);
            for (Player player : playersToShuffle) {
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.ENCHANTMENT.getPredicate(), Predicates.and((Predicate)CardType.LAND.getPredicate(), (Predicate)Predicates.not((Predicate)SuperType.BASIC.getPredicate()))}));
    }
}

