/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class WeatheredSentinelsLastTurnAttackersWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> playerMap = new HashMap<UUID, Set<UUID>>();

    WeatheredSentinelsLastTurnAttackersWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case BEGINNING_PHASE_PRE: {
                this.playerMap.remove(game.getActivePlayerId());
                return;
            }
            case ATTACKER_DECLARED: {
                UUID attacker = event.getPlayerId();
                Set defenders = this.playerMap.getOrDefault(attacker, new HashSet());
                defenders.add(event.getTargetId());
                this.playerMap.put(attacker, defenders);
            }
        }
    }

    boolean checkPlayer(UUID attackerId, UUID defenderId) {
        if (attackerId == null || defenderId == null) {
            return false;
        }
        Set<UUID> defendersLastTurn = this.playerMap.get(defenderId);
        return defendersLastTurn != null && defendersLastTurn.contains(attackerId);
    }
}

