/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WeatherlightCompleatedEffect
extends ContinuousEffectImpl {
    WeatherlightCompleatedEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "as long as {this} has four or more phyresis counters on it, it's a Phyrexian creature in addition to its other types";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private WeatherlightCompleatedEffect(WeatherlightCompleatedEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WeatherlightCompleatedEffect copy() {
        return new WeatherlightCompleatedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.PHYRESIS) < 4) {
            return false;
        }
        permanent.addCardType(game, new CardType[]{CardType.CREATURE});
        permanent.addSubType(game, new SubType[]{SubType.PHYREXIAN});
        return true;
    }
}

