/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WebOfInertiaRestrictionEffect
extends RestrictionEffect {
    private final UUID attackerID;

    WebOfInertiaRestrictionEffect(UUID attackerID) {
        super(Duration.EndOfTurn);
        this.attackerID = attackerID;
    }

    private WebOfInertiaRestrictionEffect(WebOfInertiaRestrictionEffect effect) {
        super((RestrictionEffect)effect);
        this.attackerID = effect.attackerID;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(this.attackerID);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        if (defenderId == null) {
            return true;
        }
        return !defenderId.equals(source.getControllerId());
    }

    public WebOfInertiaRestrictionEffect copy() {
        return new WebOfInertiaRestrictionEffect(this);
    }
}

