/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.LifelinkAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WeddingInvitationEffect
extends OneShotEffect {
    WeddingInvitationEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a Vampire, it also gains lifelink until end of turn";
    }

    private WeddingInvitationEffect(WeddingInvitationEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeddingInvitationEffect copy() {
        return new WeddingInvitationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null || !permanent.hasSubtype(SubType.VAMPIRE, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)LifelinkAbility.getInstance(), Duration.EndOfTurn), source);
        return true;
    }
}

