/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WeddingRingEffect
extends OneShotEffect {
    WeddingRingEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent creates a token that's a copy of it";
    }

    private WeddingRingEffect(WeddingRingEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeddingRingEffect copy() {
        return new WeddingRingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        return new CreateTokenCopyTargetEffect(player.getId()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
    }
}

