/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;

class WeddingRingTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent();
    private final boolean drawCards;

    WeddingRingTriggeredAbility(boolean drawCards) {
        super(Zone.BATTLEFIELD, null);
        this.drawCards = drawCards;
    }

    private WeddingRingTriggeredAbility(WeddingRingTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.drawCards = ability.drawCards;
    }

    public WeddingRingTriggeredAbility copy() {
        return new WeddingRingTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return this.drawCards ? event.getType() == GameEvent.EventType.DREW_CARD : event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!(game.isActivePlayer(event.getPlayerId()) && game.getOpponents(this.getControllerId()).contains(event.getPlayerId()) && game.getBattlefield().contains(filter, event.getPlayerId(), (Ability)this, game, 1))) {
            return false;
        }
        this.getEffects().clear();
        if (this.drawCards) {
            this.addEffect((Effect)new DrawCardSourceControllerEffect(1));
        } else {
            this.addEffect((Effect)new GainLifeEffect(event.getAmount()));
        }
        return true;
    }

    public String getRule() {
        return "Whenever an opponent who controls an artifact named Wedding Ring " + (this.drawCards ? "draws a card during their turn, you draw a card." : "gains life during their turn, you gain that much life.");
    }

    static {
        filter.add((Predicate)new NamePredicate("Wedding Ring"));
    }
}

