/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ClashEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WeedStrangleEffect
extends OneShotEffect {
    WeedStrangleEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature. Clash with an opponent. If you win, you gain life equal to that creature's toughness";
    }

    private WeedStrangleEffect(WeedStrangleEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeedStrangleEffect copy() {
        return new WeedStrangleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creature != null) {
            creature.destroy(source, game, false);
            if (new ClashEffect().apply(game, source)) {
                controller.gainLife(creature.getToughness().getValue(), game, source);
            }
            return true;
        }
        return false;
    }
}

