/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class WeirdHarvestEffect
extends OneShotEffect {
    WeirdHarvestEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player may search their library for up to X creature cards, reveal those cards, put them into their hand, then shuffle";
    }

    private WeirdHarvestEffect(WeirdHarvestEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeirdHarvestEffect copy() {
        return new WeirdHarvestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && (xValue = ((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue()) > 0) {
            ArrayList<Player> usingPlayers = new ArrayList<Player>();
            this.chooseAndSearchLibrary(usingPlayers, controller, xValue, source, sourceObject, game);
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                if (playerId.equals(controller.getId()) || (player = game.getPlayer(playerId)) == null) continue;
                this.chooseAndSearchLibrary(usingPlayers, player, xValue, source, sourceObject, game);
            }
            for (Player player : usingPlayers) {
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    private void chooseAndSearchLibrary(List<Player> usingPlayers, Player player, int xValue, Ability source, MageObject sourceObject, Game game) {
        if (player.chooseUse(Outcome.PutCardInPlay, "Search your library for up " + xValue + " creature cards and put them into your hand?", source, game)) {
            usingPlayers.add(player);
            TargetCardInLibrary target = new TargetCardInLibrary(0, xValue, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            if (player.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
                CardsImpl cards = new CardsImpl((Collection)target.getTargets());
                player.moveCards((Cards)cards, Zone.HAND, source, game);
                player.revealCards(sourceObject.getIdName() + " (" + player.getName() + ')', (Cards)cards, game);
            }
        }
    }
}

