/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class WelcomeToTheFoldEffect
extends GainControlTargetEffect {
    WelcomeToTheFoldEffect(Duration duration, boolean fixedControl) {
        super(duration, fixedControl);
        this.staticText = "Gain control of target creature if its toughness is 2 or less. If this spell's madness cost was paid, instead gain control of that creature if its toughness is X or less";
    }

    private WelcomeToTheFoldEffect(WelcomeToTheFoldEffect effect) {
        super((GainControlTargetEffect)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent;
            int maxToughness = 2;
            ManaCosts manaCosts = source.getManaCostsToPay();
            if (!manaCosts.getVariableCosts().isEmpty()) {
                maxToughness = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            }
            if ((permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && permanent.getToughness().getValue() > maxToughness) {
                this.discard();
            }
        }
    }

    public WelcomeToTheFoldEffect copy() {
        return new WelcomeToTheFoldEffect(this);
    }
}

