/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WheelOfSunAndMoonEffect
extends ReplacementEffectImpl {
    WheelOfSunAndMoonEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "If a card would be put into enchanted player's graveyard from anywhere, instead that card is revealed and put on the bottom of that player's library";
    }

    private WheelOfSunAndMoonEffect(WheelOfSunAndMoonEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WheelOfSunAndMoonEffect copy() {
        return new WheelOfSunAndMoonEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment;
        Card card;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && (card = game.getCard(event.getTargetId())) != null && (enchantment = game.getPermanent(source.getSourceId())) != null && enchantment.getAttachedTo() != null && card.isOwnedBy(enchantment.getAttachedTo());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null && (card = game.getCard(event.getTargetId())) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            return true;
        }
        return false;
    }
}

