/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WhirlpoolWarriorActivatedEffect
extends OneShotEffect {
    WhirlpoolWarriorActivatedEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player shuffles the cards from their hand into their library, then draws that many cards";
    }

    private WhirlpoolWarriorActivatedEffect(WhirlpoolWarriorActivatedEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhirlpoolWarriorActivatedEffect copy() {
        return new WhirlpoolWarriorActivatedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            LinkedHashMap<UUID, Integer> playerCards = new LinkedHashMap<UUID, Integer>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                int cardsHand;
                player = game.getPlayer(playerId);
                if (player == null || (cardsHand = player.getHand().size()) <= 0) continue;
                playerCards.put(playerId, cardsHand);
                player.moveCards(player.getHand(), Zone.LIBRARY, source, game);
                player.shuffleLibrary(source, game);
            }
            for (Map.Entry entry : playerCards.entrySet()) {
                player = game.getPlayer((UUID)entry.getKey());
                if (player == null) continue;
                player.drawCards(((Integer)entry.getValue()).intValue(), source, game);
            }
            return true;
        }
        return false;
    }
}

