/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class WhirlwindDenialEffect
extends OneShotEffect {
    WhirlwindDenialEffect() {
        super(Outcome.Benefit);
        this.staticText = "For each spell and ability your opponents control, counter it unless its controller pays {4}.";
    }

    private WhirlwindDenialEffect(WhirlwindDenialEffect effect) {
        super((OneShotEffect)effect);
    }

    public WhirlwindDenialEffect copy() {
        return new WhirlwindDenialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        LinkedList<StackObject> stackObjectsToCounter = new LinkedList<StackObject>();
        ManaCost cost = ManaUtil.createManaCost((int)4, (boolean)false);
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (playerId.equals(source.getControllerId())) continue;
            Player player = game.getPlayer(playerId);
            for (StackObject stackObject : game.getStack()) {
                if (!playerId.equals(stackObject.getControllerId())) continue;
                if (player == null) {
                    stackObjectsToCounter.add(stackObject);
                    continue;
                }
                if (cost.canPay(source, source, playerId, game) && player.chooseUse(this.outcome, "Pay {4} to prevent " + stackObject.getIdName() + " from being countered?", source, game) && cost.pay(source, game, source, stackObject.getControllerId(), false)) {
                    game.informPlayers(player.getLogName() + " pays the cost to prevent " + stackObject.getIdName() + " from being countered.");
                    continue;
                }
                game.informPlayers(stackObject.getIdName() + " will be countered as " + player.getLogName() + " does not pay the cost.");
                stackObjectsToCounter.add(stackObject);
            }
        }
        for (StackObject toCounter : stackObjectsToCounter) {
            game.getStack().counter(toCounter.getId(), source, game);
        }
        return true;
    }
}

