/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WhiskAwayEffect
extends OneShotEffect {
    WhiskAwayEffect() {
        super(Outcome.Removal);
        this.staticText = "Put target attacking or blocking creature on top of its owner's library";
    }

    private WhiskAwayEffect(WhiskAwayEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (targetCreature != null && controller != null) {
            return controller.putCardsOnTopOfLibrary((Card)targetCreature, game, source, true);
        }
        return false;
    }

    public WhiskAwayEffect copy() {
        return new WhiskAwayEffect(this);
    }
}

