/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.cards.w.WhisperingSnitchWatcher;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class WhisperingSnitchTriggeredAbility
extends TriggeredAbilityImpl {
    public WhisperingSnitchTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamagePlayersEffect(1, TargetController.OPPONENT), false);
        this.addEffect((Effect)new GainLifeEffect(1));
        this.addWatcher(new WhisperingSnitchWatcher());
    }

    private WhisperingSnitchTriggeredAbility(WhisperingSnitchTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SURVEILED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            WhisperingSnitchWatcher watcher = (WhisperingSnitchWatcher)game.getState().getWatcher(WhisperingSnitchWatcher.class);
            return watcher != null && watcher.getTimesSurveiled(this.getControllerId()) == 1;
        }
        return false;
    }

    public WhisperingSnitchTriggeredAbility copy() {
        return new WhisperingSnitchTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you surveil for the first time each turn, {this} deals 1 damage to each opponent and you gain 1 life.";
    }
}

