/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class WhispersteelDaggerWatcher
extends Watcher {
    private final Map<MageObjectReference, Map<UUID, Map<UUID, Integer>>> morMap = new HashMap<MageObjectReference, Map<UUID, Map<UUID, Integer>>>();

    WhispersteelDaggerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            if (event.getApprovingObject() == null) {
                return;
            }
            this.morMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), m -> new HashMap()).computeIfAbsent(game.getOwnerId(event.getSourceId()), m -> new HashMap()).compute(event.getPlayerId(), (u, i) -> i == null ? 0 : Integer.sum(i, -1));
            return;
        }
    }

    public void reset() {
        this.morMap.clear();
        super.reset();
    }

    boolean checkPermission(UUID playerId, UUID ownerId, Ability source, Game game) {
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        if (!this.morMap.containsKey(mor)) {
            return false;
        }
        return this.morMap.get(mor).computeIfAbsent(ownerId, m -> new HashMap()).getOrDefault(playerId, 0) > 0;
    }

    void addPlayable(Ability source, UUID ownerId, Game game) {
        MageObjectReference mor = new MageObjectReference(source.getSourceId(), source.getStackMomentSourceZCC(), game);
        this.morMap.computeIfAbsent(mor, m -> new HashMap()).computeIfAbsent(ownerId, m -> new HashMap()).compute(source.getControllerId(), CardUtil::setOrIncrementValue);
    }
}

