/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class WickerfolkThresherEffect
extends OneShotEffect {
    WickerfolkThresherEffect() {
        super(Outcome.Benefit);
        this.staticText = "look at the top card of your library. If it's a land card, you may put it onto the battlefield. If you don't put the card onto the battlefield, put it into your hand";
    }

    private WickerfolkThresherEffect(WickerfolkThresherEffect effect) {
        super((OneShotEffect)effect);
    }

    public WickerfolkThresherEffect copy() {
        return new WickerfolkThresherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.lookAtCards("Top card of library", card, game);
        if (card.isLand(game) && player.chooseUse(Outcome.PutLandInPlay, "Put it onto the battlefield?", source, game)) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
        }
        if (!Zone.BATTLEFIELD.match(game.getState().getZone(card.getId()))) {
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

