/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.w.WidespreadPanicEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class WidespreadPanicTriggeredAbility
extends TriggeredAbilityImpl {
    public WidespreadPanicTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new WidespreadPanicEffect(), false);
        this.setTriggerPhrase("Whenever a spell or ability causes its controller to shuffle their library, ");
    }

    private WidespreadPanicTriggeredAbility(WidespreadPanicTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WidespreadPanicTriggeredAbility copy() {
        return new WidespreadPanicTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LIBRARY_SHUFFLED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(game.getControllerId(event.getSourceId()))) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }
}

