/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.CascadeAbility;
import mage.cards.w.FirstSpellCastFromExileEachTurnCondition;
import mage.cards.w.WildMagicSorcererWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;

class WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect
extends ContinuousEffectImpl {
    private final Ability cascadeAbility = new CascadeAbility();

    public WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "The first spell you cast from exile each turn has cascade";
    }

    private WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect(WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect copy() {
        return new WildMagicSorcererGainCascadeFirstSpellCastFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        WildMagicSorcererWatcher watcher = (WildMagicSorcererWatcher)game.getState().getWatcher(WildMagicSorcererWatcher.class);
        if (controller == null || watcher == null) {
            return false;
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || stackObject.isCopy() || !stackObject.isControlledBy(source.getControllerId())) continue;
            Spell spell = (Spell)stackObject;
            if (!FirstSpellCastFromExileEachTurnCondition.instance.apply(game, source)) continue;
            game.getState().addOtherAbility(spell.getCard(), this.cascadeAbility);
        }
        return true;
    }
}

