/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WildMagicSurgeEffect
extends OneShotEffect {
    WildMagicSurgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target permanent an opponent controls. Its controller reveals cards from the top of their library until they reveal a permanent card that shares a card type with that permanent. They put that card onto the battlefield and the rest on the bottom of their library in a random order";
    }

    private WildMagicSurgeEffect(WildMagicSurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WildMagicSurgeEffect copy() {
        return new WildMagicSurgeEffect(this);
    }

    private static final Card loopCards(List<CardType> cardTypes, Player player, Cards cards, Ability source, Game game) {
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isPermanent(game)) continue;
            if (!card.getCardType(game).stream().anyMatch(cardTypes::contains)) continue;
            return card;
        }
        return null;
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        Player player = game.getPlayer(permanent.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card card = WildMagicSurgeEffect.loopCards(permanent.getCardType(game), player, (Cards)cards, source, game);
        player.revealCards(source, (Cards)cards, game);
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

