/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WillOfTheTemurEffect
extends OneShotEffect {
    WillOfTheTemurEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of target permanent, except it's a 4/4 Dragon creature with flying in addition to its other types";
    }

    private WillOfTheTemurEffect(WillOfTheTemurEffect effect) {
        super((OneShotEffect)effect);
    }

    public WillOfTheTemurEffect copy() {
        return new WillOfTheTemurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        return new CreateTokenCopyTargetEffect().setPermanentModifier(token -> {
            token.addCardType(new CardType[]{CardType.CREATURE});
            token.addSubType(new SubType[]{SubType.DRAGON});
            token.setPower(4);
            token.setToughness(4);
            token.addAbility((Ability)FlyingAbility.getInstance());
        }).setSavedPermanent(permanent).apply(game, source);
    }
}

