/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class WindsOfAbandonEffect
extends OneShotEffect {
    WindsOfAbandonEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature you don't control. For each creature exiled this way, its controller searches their library for a basic land card. Those players put those cards onto the battlefield tapped, then shuffle.";
    }

    private WindsOfAbandonEffect(WindsOfAbandonEffect effect) {
        super((OneShotEffect)effect);
    }

    public WindsOfAbandonEffect copy() {
        return new WindsOfAbandonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        Player player = game.getPlayer(permanent.getControllerId());
        if (!controller.moveCards((Card)permanent, Zone.EXILED, source, game)) {
            return true;
        }
        game.processAction();
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        if (player.searchLibrary(target, source, game) && (card = player.getLibrary().getCard(target.getFirstTarget(), game)) != null) {
            player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

