/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.ElfWarriorToken;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class WindswiftSliceEffect
extends OneShotEffect {
    WindswiftSliceEffect() {
        super(Outcome.Benefit);
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
        this.staticText = "Target creature you control deals damage equal to its power to target creature you don't control. Create a number of 1/1 green Elf Warrior creature tokens equal to the amount of excess damage dealt this way.";
    }

    private WindswiftSliceEffect(WindswiftSliceEffect effect) {
        super((OneShotEffect)effect);
    }

    public WindswiftSliceEffect copy() {
        return new WindswiftSliceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.size() < 2) {
            return false;
        }
        Permanent permanent = (Permanent)permanents.get(0);
        int power = permanent.getPower().getValue();
        if (power < 1) {
            return false;
        }
        Permanent creature = (Permanent)permanents.get(1);
        int excess = creature.damageWithExcess(power, permanent.getId(), source, game);
        if (excess > 0) {
            new ElfWarriorToken().putOntoBattlefield(excess, game, source);
        }
        return true;
    }
}

