/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;

class WingPunctureEffect
extends OneShotEffect {
    WingPunctureEffect() {
        super(Outcome.Damage);
        this.staticText = "Target creature you control deals damage equal to its power to target creature with flying";
    }

    private WingPunctureEffect(WingPunctureEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = game.getPermanent(source.getFirstTarget());
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(source.getFirstTarget(), Zone.BATTLEFIELD);
        }
        Permanent targetPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (sourcePermanent != null && targetPermanent != null) {
            targetPermanent.damage(sourcePermanent.getPower().getValue(), sourcePermanent.getId(), source, game, false, true);
            return true;
        }
        return false;
    }

    public WingPunctureEffect copy() {
        return new WingPunctureEffect(this);
    }
}

