/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.players.Player;

class WingStormEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public WingStormEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to each player equal to twice the number of creatures with flying that player controls";
    }

    private WingStormEffect(WingStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public WingStormEffect copy() {
        return new WingStormEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player;
                int amount = game.getBattlefield().countAll((FilterPermanent)filter, playerId, game);
                if (amount <= 0 || (player = game.getPlayer(playerId)) == null) continue;
                player.damage(amount * 2, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)new AbilityPredicate(FlyingAbility.class));
    }
}

