/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

public final class Wirecat
extends CardImpl {
    public Wirecat(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}, "{4}");
        this.subtype.add((Object)SubType.CAT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(3);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new WirecatEffect()));
    }

    private Wirecat(Wirecat card) {
        super((CardImpl)card);
    }

    public Wirecat copy() {
        return new Wirecat(this);
    }

    static class WirecatEffect
    extends RestrictionEffect {
        public WirecatEffect() {
            super(Duration.WhileOnBattlefield);
            this.staticText = "{this} can't attack or block if an enchantment is on the battlefield";
        }

        private WirecatEffect(WirecatEffect effect) {
            super((RestrictionEffect)effect);
        }

        public WirecatEffect copy() {
            return new WirecatEffect(this);
        }

        public boolean canAttackCheckAfter(int numberOfAttackers, Ability source, Game game, boolean canUseChooseDialogs) {
            return false;
        }

        public boolean canBlockCheckAfter(Ability source, Game game, boolean canUseChooseDialogs) {
            return false;
        }

        public boolean applies(Permanent permanent, Ability source, Game game) {
            if (permanent.getId().equals(source.getSourceId())) {
                return game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT, source, game, 1);
            }
            return false;
        }
    }
}

