/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.w.WishWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class WishPlayFromSideboardEffect
extends AsThoughEffectImpl {
    WishPlayFromSideboardEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
    }

    private WishPlayFromSideboardEffect(WishPlayFromSideboardEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public WishPlayFromSideboardEffect copy() {
        return new WishPlayFromSideboardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (source.getControllerId().equals(affectedControllerId)) {
            Player controller = game.getPlayer(source.getControllerId());
            MageObject sourceObject = source.getSourceObject(game);
            UUID mainCardId = CardUtil.getMainCardId((Game)game, (UUID)objectId);
            if (controller != null && sourceObject != null && controller.getSideboard().contains((Object)mainCardId)) {
                WishWatcher watcher = (WishWatcher)game.getState().getWatcher(WishWatcher.class);
                return watcher != null && !watcher.isAbilityUsed(new MageObjectReference(sourceObject, game));
            }
        }
        return false;
    }
}

