/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class WitchstalkerTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterCard filter = new FilterCard("blue or black spell");

    public WitchstalkerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance()), false);
    }

    private WitchstalkerTriggeredAbility(WitchstalkerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && filter.match((Card)spell, game) && game.getOpponents(this.getControllerId()).contains(spell.getControllerId()) && game.isActivePlayer(this.getControllerId());
    }

    public String getRule() {
        return "Whenever an opponent casts a blue or black spell during your turn, put a +1/+1 counter on {this}.";
    }

    public WitchstalkerTriggeredAbility copy() {
        return new WitchstalkerTriggeredAbility(this);
    }

    static {
        filter.add(Predicates.or((Predicate)new ColorPredicate(ObjectColor.BLUE), (Predicate)new ColorPredicate(ObjectColor.BLACK)));
    }
}

