/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamagePlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WithGreatPowerEffect
extends ReplacementEffectImpl {
    WithGreatPowerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.RedirectDamage);
        this.staticText = "all damage that would be dealt to you is dealt to enchanted creature instead";
    }

    private WithGreatPowerEffect(WithGreatPowerEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        DamagePlayerEvent damageEvent = (DamagePlayerEvent)event;
        Optional.ofNullable(event).map(GameEvent::getSourceId).map(arg_0 -> ((Game)game).getPermanent(arg_0)).map(Permanent::getAttachedTo).map(arg_0 -> ((Game)game).getPermanent(arg_0)).ifPresent(permanent -> permanent.damage(damageEvent.getAmount(), event.getSourceId(), source, game, damageEvent.isCombatDamage(), damageEvent.isPreventable()));
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getPlayerId());
    }

    public WithGreatPowerEffect copy() {
        return new WithGreatPowerEffect(this);
    }
}

