/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.effects.common.MillCardsTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.w.WitherbloomCommandEffect;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.TargetPlayer;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetOpponent;

public final class WitherbloomCommand
extends CardImpl {
    private static final FilterPermanent filter = new FilterNonlandPermanent("noncreature, nonland permanent with mana value 2 or less");

    public WitherbloomCommand(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{B}{G}");
        this.getSpellAbility().getModes().setMinModes(2);
        this.getSpellAbility().getModes().setMaxModes(2);
        this.getSpellAbility().addEffect((Effect)new MillCardsTargetEffect(3));
        this.getSpellAbility().addEffect((Effect)new WitherbloomCommandEffect());
        this.getSpellAbility().addTarget((Target)new TargetPlayer());
        Mode mode = new Mode((Effect)new DestroyTargetEffect());
        mode.addTarget((Target)new TargetPermanent(filter));
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new BoostTargetEffect(-3, -1));
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().addMode(mode);
        mode = new Mode((Effect)new LoseLifeTargetEffect(2));
        mode.addEffect((Effect)new GainLifeEffect(2).concatBy("and"));
        mode.addTarget((Target)new TargetOpponent());
        this.getSpellAbility().addMode(mode);
    }

    private WitherbloomCommand(WitherbloomCommand card) {
        super((CardImpl)card);
    }

    public WitherbloomCommand copy() {
        return new WitherbloomCommand(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

