/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WoeleecherEffect
extends OneShotEffect {
    WoeleecherEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Remove a -1/-1 counter from target creature. If you do, you gain 2 life";
    }

    private WoeleecherEffect(WoeleecherEffect effect) {
        super((OneShotEffect)effect);
    }

    public WoeleecherEffect copy() {
        return new WoeleecherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        Player you = game.getPlayer(source.getControllerId());
        if (target != null && you != null) {
            int numberCountersOriginal = target.getCounters(game).getCount(CounterType.M1M1);
            target.removeCounters(CounterType.M1M1.createInstance(), source, game);
            if (target.getCounters(game).getCount(CounterType.M1M1) < numberCountersOriginal) {
                you.gainLife(2, game, source);
                return true;
            }
        }
        return false;
    }
}

