/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WojekEmbermageEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent FILTER = new FilterCreaturePermanent();

    WojekEmbermageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to target creature and each other creature that shares a color with it";
    }

    private WojekEmbermageEffect(WojekEmbermageEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            ObjectColor targetColor = target.getColor(game);
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)FILTER, source.getControllerId(), game)) {
                if (!target.getId().equals(permanent.getId()) && !permanent.getColor(game).shares(targetColor)) continue;
                permanent.damage(1, source.getSourceId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }

    public WojekEmbermageEffect copy() {
        return new WojekEmbermageEffect(this);
    }
}

