/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.abilities.effects.common.RevealLibraryPutIntoHandEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;

class WoodSageEffect
extends OneShotEffect {
    WoodSageEffect() {
        super(Outcome.DrawCard);
        this.staticText = "choose a creature card name. Reveal the top four cards of your library and put all of them with that name into your hand. Put the rest into your graveyard";
    }

    private WoodSageEffect(WoodSageEffect effect) {
        super((OneShotEffect)effect);
    }

    public WoodSageEffect copy() {
        return new WoodSageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.CREATURE_NAME.getChoice(controller, game, source, false);
        FilterCreatureCard filter = new FilterCreatureCard("all of them with that name");
        filter.add((Predicate)new NamePredicate(cardName));
        new RevealLibraryPutIntoHandEffect(4, (FilterCard)filter, Zone.GRAVEYARD).apply(game, source);
        return true;
    }
}

