/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WordsOfWarEffect
extends ReplacementEffectImpl {
    WordsOfWarEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "The next time you would draw a card this turn, {this} deals 2 damage to any target instead.";
    }

    private WordsOfWarEffect(WordsOfWarEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WordsOfWarEffect copy() {
        return new WordsOfWarEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                player.damage(2, source.getSourceId(), source, game);
                this.used = true;
                this.discard();
                return true;
            }
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                permanent.damage(2, source.getSourceId(), source, game, false, true);
                this.used = true;
                this.discard();
                return true;
            }
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used) {
            return source.isControlledBy(event.getPlayerId());
        }
        return false;
    }
}

