/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WorldfireEffect
extends OneShotEffect {
    private static FilterPermanent filter = new FilterPermanent();

    public WorldfireEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile all permanents. Exile all cards from all hands and graveyards. Each player's life total becomes 1";
    }

    private WorldfireEffect(WorldfireEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldfireEffect copy() {
        return new WorldfireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.moveToExile(null, "", source, game);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card c;
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            for (UUID cid : player.getHand().copy()) {
                c = game.getCard(cid);
                if (c == null) continue;
                c.moveToExile(null, null, source, game);
            }
            for (UUID cid : player.getGraveyard().copy()) {
                c = game.getCard(cid);
                if (c == null) continue;
                c.moveToExile(null, null, source, game);
            }
            player.setLife(1, game, source);
        }
        return true;
    }
}

