/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

class WorldgorgerDragonLeavesEffect
extends OneShotEffect {
    WorldgorgerDragonLeavesEffect() {
        super(Outcome.Neutral);
        this.staticText = "return the exiled cards to the battlefield under their owners' control";
    }

    private WorldgorgerDragonLeavesEffect(WorldgorgerDragonLeavesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            int zoneChangeCounter = sourceObject instanceof PermanentToken ? source.getStackMomentSourceZCC() : source.getStackMomentSourceZCC() - 1;
            ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)zoneChangeCounter));
            if (exile != null) {
                return controller.moveCards(exile.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
            }
        }
        return false;
    }

    public WorldgorgerDragonLeavesEffect copy() {
        return new WorldgorgerDragonLeavesEffect(this);
    }
}

