/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.List;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WorldslayerEffect
extends OneShotEffect {
    WorldslayerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "destroy all permanents other than {this}";
    }

    private WorldslayerEffect(WorldslayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public WorldslayerEffect copy() {
        return new WorldslayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents(source.getControllerId(), game);
        for (Permanent permanent : permanents) {
            if (Objects.equals(permanent.getId(), source.getSourceId())) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

