/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class WoundReflectionEffect
extends OneShotEffect {
    public WoundReflectionEffect() {
        super(Outcome.LoseLife);
        this.staticText = "each opponent loses life equal to the life they lost this turn";
    }

    private WoundReflectionEffect(WoundReflectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public WoundReflectionEffect copy() {
        return new WoundReflectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (controller != null && watcher != null) {
            for (UUID playerId : game.getOpponents(controller.getId())) {
                int lifeLost;
                Player opponent = game.getPlayer(playerId);
                if (opponent == null || (lifeLost = watcher.getLifeLost(playerId)) <= 0) continue;
                opponent.loseLife(lifeLost, game, source, false);
            }
            return true;
        }
        return false;
    }
}

