/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.w.WrathfulRaptorsEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterAnyTarget;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetPermanentOrPlayer;

class WrathfulRaptorsTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    private static final FilterPermanentOrPlayer filter = new FilterAnyTarget("any target that isn't a Dinosaur");

    WrathfulRaptorsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new WrathfulRaptorsEffect());
        this.addTarget((Target)new TargetPermanentOrPlayer(filter));
    }

    private WrathfulRaptorsTriggeredAbility(WrathfulRaptorsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public WrathfulRaptorsTriggeredAbility copy() {
        return new WrathfulRaptorsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent dinosaur = game.getPermanent(event.getTargetId());
        int damage = event.getAmount();
        if (dinosaur == null || damage < 1 || !dinosaur.isControlledBy(this.getControllerId()) || !dinosaur.hasSubtype(SubType.DINOSAUR, game)) {
            return false;
        }
        this.getEffects().setValue("damagedPermanent", (Object)dinosaur);
        this.getEffects().setValue("damage", (Object)damage);
        return true;
    }

    public String getRule() {
        return "Whenever a Dinosaur you control is dealt damage, it deals that much damage to any target that isn't a Dinosaur.";
    }

    static {
        filter.getPermanentFilter().add(Predicates.not((Predicate)SubType.DINOSAUR.getPredicate()));
    }
}

