/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class WreckAndRebuildEffect
extends OneShotEffect {
    WreckAndRebuildEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may put a land card from your graveyard onto the battlefield tapped";
    }

    private WreckAndRebuildEffect(WreckAndRebuildEffect effect) {
        super((OneShotEffect)effect);
    }

    public WreckAndRebuildEffect copy() {
        return new WreckAndRebuildEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInYourGraveyard targetCard = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND, true);
        player.choose(this.outcome, (Target)targetCard, source, game);
        Card card = game.getCard(targetCard.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

