/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.PutIntoGraveFromBattlefieldThisTurnPredicate;
import mage.game.Game;
import mage.game.permanent.token.PowerstoneToken;
import mage.players.Player;

class WreckHunterEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterNonlandCard();

    WreckHunterEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target player. You create a tapped Powerstone token for each nonland card in that player's graveyard that was put there from the battlefield this turn";
    }

    private WreckHunterEffect(WreckHunterEffect effect) {
        super((OneShotEffect)effect);
    }

    public WreckHunterEffect copy() {
        return new WreckHunterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int count = player.getGraveyard().count(filter, game);
        return count > 0 && new PowerstoneToken().putOntoBattlefield(count, game, source, source.getControllerId(), true, false);
    }

    static {
        filter.add((Predicate)PutIntoGraveFromBattlefieldThisTurnPredicate.instance);
    }
}

