/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class WretchedBonemassGainAbilityEffect
extends ContinuousEffectImpl {
    WretchedBonemassGainAbilityEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has flying as long as an exiled card used to craft it has flying. The same is true for first strike, double strike, deathtouch, haste, hexproof, indestructible, lifelink, menace, protection, reach, trample, and vigilance.";
    }

    private WretchedBonemassGainAbilityEffect(WretchedBonemassGainAbilityEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public WretchedBonemassGainAbilityEffect copy() {
        return new WretchedBonemassGainAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ExileZone exileZone;
        Permanent wretchedBonemass = source.getSourcePermanentIfItStillExists(game);
        if (wretchedBonemass != null && (exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (UUID)wretchedBonemass.getId(), (int)(wretchedBonemass.getZoneChangeCounter(game) - 2)))) != null && !exileZone.isEmpty()) {
            Set cardsInExile = exileZone.getCards(game);
            for (Card card : cardsInExile) {
                for (Ability a : card.getAbilities()) {
                    if (a instanceof FlyingAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof FirstStrikeAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof DoubleStrikeAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof DeathtouchAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof HasteAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof HexproofAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof IndestructibleAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof LifelinkAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof MenaceAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof ProtectionAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof IndestructibleAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof ReachAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (a instanceof TrampleAbility) {
                        wretchedBonemass.addAbility(a, source.getSourceId(), game);
                    }
                    if (!(a instanceof VigilanceAbility)) continue;
                    wretchedBonemass.addAbility(a, source.getSourceId(), game);
                }
            }
        }
        return true;
    }
}

