/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GreatestAmongPermanentsValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class WyllsReversalEffect
extends RollDieWithResultTableEffect {
    WyllsReversalEffect() {
        super(20, "choose target spell or ability with one or more targets. Roll a d20 and add the greatest power among creatures you control");
        this.addTableEntry(1, 14, new Effect[]{new InfoEffect("you may choose new targets for that spell or ability")});
        this.addTableEntry(15, Integer.MAX_VALUE, new Effect[]{new InfoEffect("you may choose new targets for that spell or ability. Then copy it. You may choose new targets for the copy")});
    }

    private WyllsReversalEffect(WyllsReversalEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public WyllsReversalEffect copy() {
        return new WyllsReversalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (player == null || stackObject == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 20) + GreatestAmongPermanentsValue.POWER_CONTROLLED_CREATURES.calculate(game, source, (Effect)this);
        if (result >= 1) {
            stackObject.chooseNewTargets(game, source.getControllerId(), false, false, null);
        }
        if (result >= 14) {
            stackObject.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        return true;
    }
}

