/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.abilities.effects.AsThoughManaEffect;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.ManaPoolItem;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class SpendManaAsAnyColorToCastTopOfLibraryTargetEffect
extends AsThoughEffectImpl
implements AsThoughManaEffect {
    public SpendManaAsAnyColorToCastTopOfLibraryTargetEffect() {
        super(AsThoughEffectType.SPEND_OTHER_MANA, Duration.EndOfTurn, Outcome.Benefit);
    }

    private SpendManaAsAnyColorToCastTopOfLibraryTargetEffect(SpendManaAsAnyColorToCastTopOfLibraryTargetEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public SpendManaAsAnyColorToCastTopOfLibraryTargetEffect copy() {
        return new SpendManaAsAnyColorToCastTopOfLibraryTargetEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        FixedTarget fixedTarget = (FixedTarget)this.getTargetPointer();
        UUID targetId = CardUtil.getMainCardId((Game)game, (UUID)fixedTarget.getTarget());
        Card topCard = game.getPlayer(source.getFirstTarget()).getLibrary().getFromTop(game);
        if (topCard == null) {
            return false;
        }
        if (!topCard.getId().equals(targetId) && this.canLookAtNextTopLibraryCard(game) && !this.isDiscarded()) {
            int zcc = game.getState().getZoneChangeCounter(topCard.getId());
            game.addEffect(new SpendManaAsAnyColorToCastTopOfLibraryTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(topCard.getId(), zcc)), source);
            this.discard();
        }
        return source.isControlledBy(affectedControllerId) && Objects.equals(objectId, targetId) && game.getState().getZoneChangeCounter(objectId) <= fixedTarget.getZoneChangeCounter() + 1 && (game.getState().getZone(objectId) == Zone.STACK || game.getState().getZone(objectId) == Zone.LIBRARY);
    }

    public ManaType getAsThoughManaType(ManaType manaType, ManaPoolItem mana, UUID affectedControllerId, Ability source, Game game) {
        return mana.getFirstAvailable();
    }
}

