/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class XenagosExileEffect
extends OneShotEffect {
    XenagosExileEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Exile the top seven cards of your library. You may put any number of creature and/or land cards from among them onto the battlefield";
    }

    private XenagosExileEffect(XenagosExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public XenagosExileEffect copy() {
        return new XenagosExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl exiledCards = new CardsImpl();
            exiledCards.addAllCards((Collection)controller.getLibrary().getTopCards(game, 7));
            controller.moveCards((Cards)exiledCards, Zone.EXILED, source, game);
            FilterCard filter = new FilterCard("creature and/or land cards to put onto the battlefield");
            filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)CardType.LAND.getPredicate()));
            TargetCard target1 = new TargetCard(0, Integer.MAX_VALUE, Zone.EXILED, filter);
            target1.withNotTarget(true);
            if (!exiledCards.isEmpty() && target1.canChoose(source.getControllerId(), source, game) && controller.choose(Outcome.PutCardInPlay, (Cards)exiledCards, target1, source, game)) {
                controller.moveCards((Cards)new CardsImpl((Collection)target1.getTargets()), Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

