/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class XenagosManaEffect
extends OneShotEffect {
    XenagosManaEffect() {
        super(Outcome.PutManaInPool);
        this.staticText = "Add X mana in any combination of {R} and/or {G}, where X is the number of creatures you control";
    }

    private XenagosManaEffect(XenagosManaEffect effect) {
        super((OneShotEffect)effect);
    }

    public XenagosManaEffect copy() {
        return new XenagosManaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int x = game.getBattlefield().count((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), source, game);
            if (x == 0) {
                return false;
            }
            Mana mana = new Mana();
            int redCount = player.getAmount(0, x, "How much <b>RED</b> mana add to pool? (available: " + x + ", another mana goes to <b>GREEN</b>)?", source, game);
            int greenCount = Math.max(0, x - redCount);
            mana.setRed(redCount);
            mana.setGreen(greenCount);
            if (mana.count() > 0) {
                player.getManaPool().addMana(mana, game, source);
                return true;
            }
        }
        return false;
    }
}

