/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.x;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class XuIfitOsteoharmonistEffect
extends ContinuousEffectImpl {
    XuIfitOsteoharmonistEffect() {
        super(Duration.Custom, Outcome.LoseAbility);
        this.staticText = "It's a Skeleton in addition to its other types and has no abilities";
    }

    private XuIfitOsteoharmonistEffect(XuIfitOsteoharmonistEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public XuIfitOsteoharmonistEffect copy() {
        return new XuIfitOsteoharmonistEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: {
                return true;
            }
        }
        return false;
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            this.discard();
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addSubType(game, new SubType[]{SubType.SKELETON});
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }
}

